# Script AII.4.R
library(survival)
datos<-read.csv2("DaphniaSurv.csv",header=TRUE,encoding="latin1")
attach(datos)
modelo1<-survfit(Surv(Time,Status)~FeedMode)
modelo2<-survfit(Surv(Time,Status)~Trat+Conc)
par(mfrow=c(1,2))
plot(modelo1,lty=1:4,main="Feeding mode",xlab="Tiempo (h)",ylab="Supervivencia",font.main=2,font.lab=2,cex.main=1.25)
legend(205,0.7,c("H","HM","O","OM"),lty=1:4)
plot(modelo2,lty=1:4,main="Treatment",xlab="Tiempo (h)",ylab="Supervivencia",font.main=2,font.lab=2,cex.main=1.25)
legend(205,0.7,c("NoH","NoL","SiH","SiL"),lty=1:4)
